import numpy as np
import torch
from scipy.signal import decimate

def int_down_sample(x, q):
    r""" integral multiple of sampling
    """
    if type(x) is np.ndarray:
        return decimate(x, q)
    
    elif type(x) is torch.Tensor:
        num = x.shape[0]
        out_num = int(num / q)
        idx = torch.arange(out_num, device = x.device) * q
        return torch.index_select(x, dim = 0, index = idx)

