import torch
import numpy as np

def shaping(x, sam_per_sym, filter_freq):
    '''
    This function filters and shapes the input signal for easy resampling.
    Parameters:
        x:nparray or tensor
            Input signal.
        sam_per_sym:int
            sample per symbol,If the sample per symbol=1, the signal is returned directly, and if not, the signal is filtered 
            and shaped.
        filter_freq:class object
            The input signal is filtered and shaped when the sample per symbol is not 1.
    Returns:
        out:nparray or tensor
            The input signal is returned when the sample rate is 1, and the input signal is zeroed in the time domain and 
            filtered to shape the output when it is not 1.
    '''

    if sam_per_sym == 1:
        return x
    else:
        pre_shape = np.zeros((x.shape[0], sam_per_sym)) + 0j
        pre_shape[:,0] = x
        pre_shape = pre_shape.flatten()
        shaped = filter_freq(pre_shape)
    
        return shaped
