import torch
import numpy as np

def awgn_real(x, snr_db=15, device='cpu', data_mode = 'numpy'):
    '''
    
    
    '''
    if data_mode == 'tensor':
        sig_p = torch.mean(x ** 2).detach()
        noise = torch.randn((x.shape[0]), device = device) 
    elif data_mode == 'numpy':    
        sig_p = np.mean(x ** 2)
        noise = np.random.randn(x.shape[0])
    else:
        raise AttributeError("ERROR:data_mode is not defined as 'tensor' or 'numpy' ")
    n_power = sig_p / (10 ** (snr_db / 10))
    noise = noise * ((n_power/2) ** 0.5)
    y = x + noise
    return y

def awgn_complex(x, snr_db, rand_seed=-1,device='cpu',data_mode = 'numpy'):
    '''
    '''
    if data_mode == 'tensor':
        sig_p = torch.mean(torch.abs(x) ** 2).detach()
    elif data_mode == 'numpy':    
        sig_p = np.mean(np.abs(x) ** 2)
    n_power = sig_p / (10 ** (snr_db / 10))
    if data_mode == 'numpy':
        if rand_seed == -1:
            rng_i = np.random.default_rng()
            rng_q = np.random.default_rng()
        else:
            rng_i = np.random.default_rng(rand_seed) # use different seeds for the real and imaginary parts
            rng_q = np.random.default_rng(rand_seed + 10026)
        num = len(x)
        n = np.sqrt(n_power/2) * (rng_i.standard_normal(num)\
                + 1j * rng_q.standard_normal(num)) 
    elif data_mode =='tensor':
        rng_i = torch.Generator(device=device)
        rng_q = torch.Generator(device=device)
        if rand_seed == -1:
            rng_i.seed()
            rng_q.seed()
        else:
            rng_i = rng_i.manual_seed(rand_seed)            
            rng_q = rng_q.manual_seed(rand_seed + 10026) 
        num = len(x)
        n = np.sqrt(n_power/2) * (torch.randn(num, generator = rng_i, device = device) \
            + 1j * torch.randn(num, generator = rng_q, device = device))
    else:
        raise AttributeError("ERROR:data_mode is not defined as 'tensor' or 'numpy' ")
    y = x + n
    return y

def awgn(sigin, snr_db, ch_random,rand_seed,device='cpu', data_mode = 'numpy'):
    '''
    Add guassian white noise to input signal sigin.

    Parameters
    ----------
    sigin: list
        The input signal of AWGN channel.
    snr_db: 
        The SNR of the simulated AWGN channel,in [dB].
    rand_seed: int
        The seed to control the generator.If set -1 ,the noise is random and different each time.
    data_mode:str,{'numpy','tensor'},optional
        The data type used in operation.Default:'numpy'.
    
    Returns
    -------
    sigout : list
        The signal with noise.

    Raises
    ------
    AttributeError
    When the value of data_mode is not legitimate.
    '''
    sigout = []
    if ch_random:
        rand_seed =-1
    for i_p in range(len(sigin)):
        sigout.append(awgn_complex(sigin[i_p], snr_db,rand_seed,device,data_mode))
    return sigout

