import setuptools

setuptools.setup(
        name = "IFTS",
        version = "0.1",
        author = "上海交通大学智能光纤系统实验室",
        author_email = "fibertrans@outlook.com",
        description = "智能光传输仿真平台",	

        long_description = "IFTS Module",
        license = 'GNU General Public License v3',
        long_description_content_type = "text/markdown",

        url = "https://ifibertrans.sjtu.edu.cn",

        packages = setuptools.find_packages(),
        include_package_data = True,

        install_requires = [
            'seaborn>=0.9.0',
            'scipy>=1.6.1',
            'tqdm>=4.26.0',
            'pyyaml>=3.13',
            'torch>=1.8.1',
            'sklearn>=0.0'
        ],

        python_requires = '>=3.7',
        
        classifiers=[
        #这个文件适用的python版本，安全等等，我这里只写入了版本    
        "Programming Language :: Python :: 3",

        # 许可证信息
        'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
            ],

            # 希望被打包的文件
        package_data={
            '':['*.yml'],
            '':['*.txt'],
            '':['*.mat']
                },
        )
