import numpy as np
import torch

def ser(x, y, receive_sym):
    """
    Calculate the SER (symbol error rate) of the transmission process according 
    to the transmission data and received data
    Parameters:
    x: array_like
    Input data array. It is the compared data in the calculation, which is 
    generally the sequence of transmission symbols
    y: array_like
    Input data array. It is the comparison data in the calculation, which is 
    generally the sequence of received symbols
    receive_sym: array_like
    Received symbol sequence

    Returns:
    ser: float
    symbol error rate
    sym_error: array_like
    Transmission error symbols
    sym_error_idx: array_like
    Index of transmission error symbols
    """
    x = x.reshape(-1)
    y = y.reshape(-1)
    num = y.shape[0]
    sym_error_idx = x[x!=y]
    sym_error = receive_sym[x!=y]
    ser = sym_error.shape[0] / num 

    
    return ser, sym_error, sym_error_idx