import numpy as np

def qammap(M):
    """
    According to the alphabet size, the original constellation relative 
    to the modulation order is obtained
    Parameters:
    M: int
    alphabet size

    Returns:
    map: array_like
    Constellation corresponding to modulation order
    """
    class_num = 2 ** M
    
    if class_num == 4:
        return np.array([[1.0, 1.0],
        [ 1.0, -1.0],
        [-1.0,  1.0],
        [-1.0, -1.0]])
    
    elif class_num == 8:
        return np.array([[2.0, 1.0],
        [ 2.0, -1.0],
        [ 0.0,  1.0],
        [-0.0, -1.0],
        [ 0.0,  3.0],
        [-0.0, -3.0],
        [-2.0,  1.0],
        [-2.0, -1.0]])

    elif class_num == 16:
        return np.array([[-3.000000,-3.000000],
        [-1.000000,-3.000000],
        [3.000000,-3.000000],
        [1.000000,-3.000000],
        [-3.000000,-1.000000],
        [-1.000000,-1.000000],
        [3.000000,-1.000000],
        [1.000000,-1.000000],
        [-3.000000,3.000000],
        [-1.000000,3.000000],
        [3.000000,3.000000],
        [1.000000, 3.000000],
        [-3.000000, 1.000000],
        [-1.000000, 1.000000],
        [3.000000, 1.000000],
        [1.000000, 1.000000]
        ])
    
    elif class_num == 32:
        return np.array([[-3.000000, -5.000000],
        [-1.000000, -5.000000],
        [-3.000000, 5.000000],
        [-1.000000, 5.000000],
        [-5.000000, -3.000000],
        [-5.000000, -1.000000],
        [-5.000000, 3.000000],
        [-5.000000, 1.000000],
        [-1.000000, -3.000000],
        [-1.000000, -1.000000],
        [-1.000000, 3.000000],
        [-1.000000, 1.000000],
        [-3.000000, -3.000000],
        [-3.000000, -1.000000],
        [-3.000000, 3.000000],
        [-3.000000, 1.000000],
        [3.000000, -5.000000],
        [1.000000, -5.000000],
        [3.000000, 5.000000],
        [1.000000, 5.000000],
        [5.000000, -3.000000],
        [5.000000, -1.000000],
        [5.000000, 3.000000],
        [5.000000, 1.000000],
        [1.000000, -3.000000],
        [1.000000, -1.000000],
        [1.000000, 3.000000],
        [1.000000, 1.000000],
        [3.000000, -3.000000],
        [3.000000, -1.000000],
        [3.000000, 3.000000],
        [3.000000, 1.000000]])

    elif class_num == 64:
        return np.array([[-7.000000, -7.000000],
        [-5.000000, -7.000000],
        [-1.000000, -7.000000],
        [-3.000000, -7.000000],
        [7.000000, -7.000000],
        [5.000000, -7.000000],
        [1.000000, -7.000000],
        [3.000000, -7.000000],
        [-7.000000, -5.000000],
        [-5.000000, -5.000000],
        [-1.000000, -5.000000],
        [-3.000000, -5.000000],
        [7.000000, -5.000000],
        [5.000000, -5.000000],
        [1.000000, -5.000000],
        [3.000000, -5.000000],
        [-7.000000, -1.000000],
        [-5.000000, -1.000000],
        [-1.000000, -1.000000],
        [-3.000000, -1.000000],
        [7.000000, -1.000000],
        [5.000000, -1.000000],
        [1.000000, -1.000000],
        [3.000000, -1.000000],
        [-7.000000, -3.000000],
        [-5.000000, -3.000000],
        [-1.000000, -3.000000],
        [-3.000000, -3.000000],
        [7.000000, -3.000000],
        [5.000000, -3.000000],
        [1.000000, -3.000000],
        [3.000000, -3.000000],
        [-7.000000, 7.000000],
        [-5.000000, 7.000000],
        [-1.000000, 7.000000],
        [-3.000000, 7.000000],
        [7.000000, 7.000000],
        [5.000000, 7.000000],
        [1.000000, 7.000000],
        [3.000000, 7.000000],
        [-7.000000, 5.000000],
        [-5.000000, 5.000000],
        [-1.000000, 5.000000],
        [-3.000000, 5.000000],
        [7.000000, 5.000000],
        [5.000000, 5.000000],
        [1.000000, 5.000000],
        [3.000000, 5.000000],
        [-7.000000, 1.000000],
        [-5.000000, 1.000000],
        [-1.000000, 1.000000],
        [-3.000000, 1.000000],
        [7.000000, 1.000000],
        [5.000000, 1.000000],
        [1.000000, 1.000000],
        [3.000000, 1.000000],
        [-7.000000, 3.000000],
        [-5.000000, 3.000000],
        [-1.000000, 3.000000],
        [-3.000000, 3.000000],
        [7.000000, 3.000000],
        [5.000000, 3.000000],
        [1.000000, 3.000000],
        [3.000000, 3.000000]])
        
    elif class_num == 256:
        return np.array(
            [
            [-15.000000, 15.000000],
            [-15.000000, 13.000000],
            [-15.000000, 9.000000],
            [-15.000000, 11.000000],
            [-15.000000, 1.000000],
            [-15.000000, 3.000000],
            [-15.000000, 7.000000],
            [-15.000000, 5.000000],
            [-15.000000, -15.000000],
            [-15.000000, -13.000000],
            [-15.000000, -9.000000],
            [-15.000000, -11.000000],
            [-15.000000, -1.000000],
            [-15.000000, -3.000000],
            [-15.000000, -7.000000],
            [-15.000000, -5.000000],
            [-13.000000, 15.000000],
            [-13.000000, 13.000000],
            [-13.000000, 9.000000],
            [-13.000000, 11.000000],
            [-13.000000, 1.000000],
            [-13.000000, 3.000000],
            [-13.000000, 7.000000],
            [-13.000000, 5.000000],
            [-13.000000, -15.000000],
            [-13.000000, -13.000000],
            [-13.000000, -9.000000],
            [-13.000000, -11.000000],
            [-13.000000, -1.000000],
            [-13.000000, -3.000000],
            [-13.000000, -7.000000],
            [-13.000000, -5.000000],
            [-9.000000, 15.000000],
            [-9.000000, 13.000000],
            [-9.000000, 9.000000],
            [-9.000000, 11.000000],
            [-9.000000, 1.000000],
            [-9.000000, 3.000000],
            [-9.000000, 7.000000],
            [-9.000000, 5.000000],
            [-9.000000, -15.000000],
            [-9.000000, -13.000000],
            [-9.000000, -9.000000],
            [-9.000000, -11.000000],
            [-9.000000, -1.000000],
            [-9.000000, -3.000000],
            [-9.000000, -7.000000],
            [-9.000000, -5.000000],
            [-11.000000, 15.000000],
            [-11.000000, 13.000000],
            [-11.000000, 9.000000],
            [-11.000000, 11.000000],
            [-11.000000, 1.000000],
            [-11.000000, 3.000000],
            [-11.000000, 7.000000],
            [-11.000000, 5.000000],
            [-11.000000, -15.000000],
            [-11.000000, -13.000000],
            [-11.000000, -9.000000],
            [-11.000000, -11.000000],
            [-11.000000, -1.000000],
            [-11.000000, -3.000000],
            [-11.000000, -7.000000],
            [-11.000000, -5.000000],
            [-1.000000, 15.000000],
            [-1.000000, 13.000000],
            [-1.000000, 9.000000],
            [-1.000000, 11.000000],
            [-1.000000, 1.000000],
            [-1.000000, 3.000000],
            [-1.000000, 7.000000],
            [-1.000000, 5.000000],
            [-1.000000, -15.000000],
            [-1.000000, -13.000000],
            [-1.000000, -9.000000],
            [-1.000000, -11.000000],
            [-1.000000, -1.000000],
            [-1.000000, -3.000000],
            [-1.000000, -7.000000],
            [-1.000000, -5.000000],
            [-3.000000, 15.000000],
            [-3.000000, 13.000000],
            [-3.000000, 9.000000],
            [-3.000000, 11.000000],
            [-3.000000, 1.000000],
            [-3.000000, 3.000000],
            [-3.000000, 7.000000],
            [-3.000000, 5.000000],
            [-3.000000, -15.000000],
            [-3.000000, -13.000000],
            [-3.000000, -9.000000],
            [-3.000000, -11.000000],
            [-3.000000, -1.000000],
            [-3.000000, -3.000000],
            [-3.000000, -7.000000],
            [-3.000000, -5.000000],
            [-7.000000, 15.000000],
            [-7.000000, 13.000000],
            [-7.000000, 9.000000],
            [-7.000000, 11.000000],
            [-7.000000, 1.000000],
            [-7.000000, 3.000000],
            [-7.000000, 7.000000],
            [-7.000000, 5.000000],
            [-7.000000, -15.000000],
            [-7.000000, -13.000000],
            [-7.000000, -9.000000],
            [-7.000000, -11.000000],
            [-7.000000, -1.000000],
            [-7.000000, -3.000000],
            [-7.000000, -7.000000],
            [-7.000000, -5.000000],
            [-5.000000, 15.000000],
            [-5.000000, 13.000000],
            [-5.000000, 9.000000],
            [-5.000000, 11.000000],
            [-5.000000, 1.000000],
            [-5.000000, 3.000000],
            [-5.000000, 7.000000],
            [-5.000000, 5.000000],
            [-5.000000, -15.000000],
            [-5.000000, -13.000000],
            [-5.000000, -9.000000],
            [-5.000000, -11.000000],
            [-5.000000, -1.000000],
            [-5.000000, -3.000000],
            [-5.000000, -7.000000],
            [-5.000000, -5.000000],
            [15.000000, 15.000000],
            [15.000000, 13.000000],
            [15.000000, 9.000000],
            [15.000000, 11.000000],
            [15.000000, 1.000000],
            [15.000000, 3.000000],
            [15.000000, 7.000000],
            [15.000000, 5.000000],
            [15.000000, -15.000000],
            [15.000000, -13.000000],
            [15.000000, -9.000000],
            [15.000000, -11.000000],
            [15.000000, -1.000000],
            [15.000000, -3.000000],
            [15.000000, -7.000000],
            [15.000000, -5.000000],
            [13.000000, 15.000000],
            [13.000000, 13.000000],
            [13.000000, 9.000000],
            [13.000000, 11.000000],
            [13.000000, 1.000000],
            [13.000000, 3.000000],
            [13.000000, 7.000000],
            [13.000000, 5.000000],
            [13.000000, -15.000000],
            [13.000000, -13.000000],
            [13.000000, -9.000000],
            [13.000000, -11.000000],
            [13.000000, -1.000000],
            [13.000000, -3.000000],
            [13.000000, -7.000000],
            [13.000000, -5.000000],
            [9.000000, 15.000000],
            [9.000000, 13.000000],
            [9.000000, 9.000000],
            [9.000000, 11.000000],
            [9.000000, 1.000000],
            [9.000000, 3.000000],
            [9.000000, 7.000000],
            [9.000000, 5.000000],
            [9.000000, -15.000000],
            [9.000000, -13.000000],
            [9.000000, -9.000000],
            [9.000000, -11.000000],
            [9.000000, -1.000000],
            [9.000000, -3.000000],
            [9.000000, -7.000000],
            [9.000000, -5.000000],
            [11.000000, 15.000000],
            [11.000000, 13.000000],
            [11.000000, 9.000000],
            [11.000000, 11.000000],
            [11.000000, 1.000000],
            [11.000000, 3.000000],
            [11.000000, 7.000000],
            [11.000000, 5.000000],
            [11.000000, -15.000000],
            [11.000000, -13.000000],
            [11.000000, -9.000000],
            [11.000000, -11.000000],
            [11.000000, -1.000000],
            [11.000000, -3.000000],
            [11.000000, -7.000000],
            [11.000000, -5.000000],
            [1.000000, 15.000000],
            [1.000000, 13.000000],
            [1.000000, 9.000000],
            [1.000000, 11.000000],
            [1.000000, 1.000000],
            [1.000000, 3.000000],
            [1.000000, 7.000000],
            [1.000000, 5.000000],
            [1.000000, -15.000000],
            [1.000000, -13.000000],
            [1.000000, -9.000000],
            [1.000000, -11.000000],
            [1.000000, -1.000000],
            [1.000000, -3.000000],
            [1.000000, -7.000000],
            [1.000000, -5.000000],
            [3.000000, 15.000000],
            [3.000000, 13.000000],
            [3.000000, 9.000000],
            [3.000000, 11.000000],
            [3.000000, 1.000000],
            [3.000000, 3.000000],
            [3.000000, 7.000000],
            [3.000000, 5.000000],
            [3.000000, -15.000000],
            [3.000000, -13.000000],
            [3.000000, -9.000000],
            [3.000000, -11.000000],
            [3.000000, -1.000000],
            [3.000000, -3.000000],
            [3.000000, -7.000000],
            [3.000000, -5.000000],
            [7.000000, 15.000000],
            [7.000000, 13.000000],
            [7.000000, 9.000000],
            [7.000000, 11.000000],
            [7.000000, 1.000000],
            [7.000000, 3.000000],
            [7.000000, 7.000000],
            [7.000000, 5.000000],
            [7.000000, -15.000000],
            [7.000000, -13.000000],
            [7.000000, -9.000000],
            [7.000000, -11.000000],
            [7.000000, -1.000000],
            [7.000000, -3.000000],
            [7.000000, -7.000000],
            [7.000000, -5.000000],
            [5.000000, 15.000000],
            [5.000000, 13.000000],
            [5.000000, 9.000000],
            [5.000000, 11.000000],
            [5.000000, 1.000000],
            [5.000000, 3.000000],
            [5.000000, 7.000000],
            [5.000000, 5.000000],
            [5.000000, -15.000000],
            [5.000000, -13.000000],
            [5.000000, -9.000000],
            [5.000000, -11.000000],
            [5.000000, -1.000000],
            [5.000000, -3.000000],
            [5.000000, -7.000000],
            [5.000000, -5.000000]
            ]
        )


def gs_qammap(M):
    """
    According to the alphabet size, the geometric shaping constellation 
    relative to the modulation order is obtained
    Parameters:
    M: int
    alphabet size

    Returns:
    map: array_like
    Corresponding geometric shaping constellation
    """
    class_num = 2 ** M
    if class_num == 32:
        return np.array([[1.425736, 0.359326],
        [-1.425736, 0.359326],
        [1.425736, -0.359326],
        [-1.425736, -0.359326],
        [0.162827, 0.213894],
        [-0.162827, 0.213894],
        [0.162827, -0.213894],
        [-0.162827, -0.213894],
        [0.937898, 0.240419],
        [-0.937898, 0.240419],
        [0.937898, -0.240419],
        [-0.937898, -0.240419],
        [0.536191, 0.223461],
        [-0.536191, 0.223461],
        [0.536191, -0.223461],
        [-0.536191, -0.223461],
        [0.324207, 1.246771],
        [-0.324207, 1.246771],
        [0.324207, -1.246771],
        [-0.324207, -1.246771],
        [0.174042, 0.706463],
        [-0.174042, 0.706463],
        [0.174042, -0.706463],
        [-0.174042, -0.706463],
        [0.885189, 0.926087],
        [-0.885189, 0.926087],
        [0.885189, -0.926087],
        [-0.885189, -0.926087],
        [0.519867, 0.624999],
        [-0.519867, 0.624999],
        [0.519867, -0.624999],
        [-0.519867, -0.624999]])
    
    elif class_num == 64:
        return np.array([[1.178611, 0.890762],
        [-1.178611, 0.890762],
        [1.178611, -0.890762],
        [-1.178611, -0.890762],
        [0.313782, 1.515230],
        [-0.313782, 1.515230],
        [0.313782, -1.515230],
        [-0.313782, -1.515230],
        [0.725539, 1.030327],
        [-0.725539, 1.030327],
        [0.725539, -1.030327],
        [-0.725539, -1.030327],
        [0.252326, 1.112088],
        [-0.252326, 1.112088],
        [0.252326, -1.112088],
        [-0.252326, -1.112088],
        [0.421477, 0.133182],
        [-0.421477, 0.133182],
        [0.421477, -0.133182],
        [-0.421477, -0.133182],
        [0.133210, 0.089240],
        [-0.133210, 0.089240],
        [0.133210, -0.089240],
        [-0.133210, -0.089240],
        [0.346091, 0.290078],
        [-0.346091, 0.290078],
        [0.346091, -0.290078],
        [-0.346091, -0.290078],
        [0.119533, 0.315677],
        [-0.119533, 0.315677],
        [0.119533, -0.315677],
        [-0.119533, -0.315677],
        [0.945025, 0.460943],
        [-0.945025, 0.460943],
        [0.945025, -0.460943],
        [-0.945025, -0.460943],
        [1.157897, 0.206275],
        [-1.157897, 0.206275],
        [1.157897, -0.206275],
        [-1.157897, -0.206275],
        [0.626996, 0.688304],
        [-0.626996, 0.688304],
        [0.626996, -0.688304],
        [-0.626996, -0.688304],
        [0.208902, 0.845025],
        [-0.208902, 0.845025],
        [0.208902, -0.845025],
        [-0.208902, -0.845025],
        [0.677781, 0.171070],
        [-0.677781, 0.171070],
        [0.677781, -0.171070],
        [-0.677781, -0.171070],
        [1.554283, 0.286050],
        [-1.554283, 0.286050],
        [1.554283, -0.286050],
        [-1.554283, -0.286050],
        [0.490554, 0.502778],
        [-0.490554, 0.502778],
        [0.490554, -0.502778],
        [-0.490554, -0.502778],
        [0.162807, 0.613254],
        [-0.162807, 0.613254],
        [0.162807, -0.613254],
        [-0.162807, -0.613254]])
